﻿using System;
using System.Collections.Generic;
using System.Data;
using DataAccess.DataRows;

namespace DataAccess.DataTables
{
    partial class CurrentStateDataTable : DataTable
    {
        public CurrentStateDataTable()
        {
            this.Columns.Add(new DataColumn("INPROGRESS", typeof(int)));
            this.Columns.Add(new DataColumn("RUN_STARTUP_SCRIPT", typeof(int)));
            this.Columns.Add(new DataColumn("CURRENT_MESSAGE_ID", typeof(int)));
        }

        public CurrentStateDataRow this[int index]
        {
            get
            {
                return (CurrentStateDataRow)Rows[index];
            }
        }

        public void Add(CurrentStateDataRow row)
        {
            this.Rows.Add(row);
        }

        public void Remove(CurrentStateDataRow row)
        {
            this.Rows.Remove(row);
        }

        public CurrentStateDataRow GetNewRow()
        {
            CurrentStateDataRow row = (CurrentStateDataRow)NewRow();
            return row;
        }

        protected override Type GetRowType()
        {
            return typeof(CurrentStateDataRow);
        }

        protected override DataRow NewRowFromBuilder(DataRowBuilder builder)
        {
            return new CurrentStateDataRow(builder);
        }

        public IEnumerator<CurrentStateDataRow> GetEnumerator()
        {
            List<CurrentStateDataRow> rows = new List<CurrentStateDataRow>();

            for (int i = 0; i < this.Rows.Count; i++)
            {
                rows.Add((CurrentStateDataRow)this.Rows[i]);
            }

            return rows.GetEnumerator();
        }
    }
}
